'Altium Spiral Script
' Cober
' Date: Oct 10, 2013


Dim   Board
Dim   xm,ym    'mouse coordinates


Sub PlaceSpiralTrackFormCreate(Sender)

    Set Board = PCBServer.GetCurrentPCBBoard
    If Board is Nothing Then Exit Sub

    If Not Board.ChooseLocation(xm,ym,"Choose Spiral Track start location") Then
    End If

    xm = xm/10000               'convert to mils
    ym = ym/10000               '

    spr2form.Xloc.Text = xm
    spr2form.Yloc.Text = ym

   spr2form.LayerListBox.Text = Layer2String(Board.CurrentLayer)    'get current layer

    If (Board.DisplayUnit) Then
       spr2form.Metric.Checked = false
    Else
       spr2form.Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Xloc.Color = RGB(236, 233, 216 )
    Yloc.Color = RGB(236, 233, 216)
    GSpacing.Color = RGB(236, 233, 216)
    GWidth.Color = RGB(236, 233, 216)
    GCenter.Color = RGB(236, 233, 216)
    Turns.Color = RGB(236, 233, 216)
    ViaDia.Color = RGB(236, 233, 216)
    Drill.Color = RGB(236, 233, 216)

End Sub


Sub XPBitBtn1Click(Sender)
    Dim   Layer, Spacing, Width
    Dim   Via
    Dim   CenterX, CenterY
    Dim   Center_space

    If (Board.DisplayUnit) Then
       Metric.Checked = false
    Else
       Metric.Checked = true                   ' read 0 = Metric, 1 = Inch
    End If

    Width = (spr2form.GWidth.Text)
    Spacing = (spr2form.GSpacing.Text)

    Layer = String2Layer(LayerListBox.Text)
    Center_space =  GCenter.Text

    if (Width < 0) or (Spacing < 0) or (Center_space < 0) then
       showmessage ("Negative Value entered; results may not be good...")
    end if

    spr2form.Hide

    PCBServer.PreProcess

    'move everything to Mils
    if (Metric.Checked) Then
         MetricClick
         Metric.Checked = false
    end if

    CenterX = XLoc.Text
    CenterY = YLoc.Text

    If XPCheckBox_via.Checked Then
        'Place Via
        Via           = PCBServer.PCBObjectFactory(eViaObject, eNoDimension, eCreate_Default)
        Via.X         = MilsToCoord(CenterX)
        Via.Y         = MilsToCoord(CenterY)
        Via.Size      = MilsToCoord(ViaDia.Text)
        Via.HoleSize  = MilsToCoord(Drill.Text)
        Via.LowLayer  = eTopLayer
        Via.HighLayer = eBottomLayer
        Board.AddPCBObject(Via)
    End If

   Make_Spiral Board, Layer, CenterX, CenterY, Turns.Text, Width, Spacing, GCenter.Text, XPCheckBox_CCW.Checked

   PCBServer.PostProcess
    ' Refresh PCB workspace.
    ResetParameters
    Call AddStringParameter("Action", "Redraw")
    RunProcess("PCB:Zoom")

  Close
End Sub




sub Make_Spiral (Board, Layer, CenterX, CenterY, NumTurns, TraceWidth, Spacing, CDiameter, CClockwise)

    Dim Arc
    Dim DiameterDelta, shift, CenterDiameter
    dim ArcXoffset(2), coil_offset

'showmessage ("centerx=" & CenterX & " Width=" & width)

    CenterDiameter = CDiameter / 2.0  'not sure why, but Altium doesn't seem to think Radius is half of Diameter...
    DiameterDelta = ((Spacing/2.0) + (TraceWidth/2.0)) 'This is how much each half circle diameter shifts

    'Place 1st Arc to meet start of spiral
    Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)

    Arc.YCenter     = MilsToCoord(CenterY)
    Arc.Layer       = Layer
    Arc.LineWidth   = MilsToCoord(TraceWidth)
    if ((CenterDiameter/2 - DiameterDelta/ 2.0) < 0) then
        'Handle condition where the spacing+trace width > center diameter!
        Arc.Radius      = MilsToCoord( CenterDiameter/2.0 - DiameterDelta/4.0)
        Arc.XCenter    = MilsToCoord(CenterX + CenterDiameter/4.0 - TraceWidth)
    else
        Arc.Radius      = MilsToCoord(CenterDiameter/2.0 - DiameterDelta/ 2.0)
        Arc.XCenter    = MilsToCoord(CenterX + CenterDiameter/2.0)
    end if

    if (CClockwise) then
        Arc.StartAngle = 180
        Arc.EndAngle   = 0
    else
        Arc.StartAngle = 0
        Arc.EndAngle   = 180
    End if
    Board.AddPCBObject(Arc)


    if (CClockwise) then
        ArcXOffset(0) = -DiameterDelta/ 2.0
        ArcXOffset(1) = DiameterDelta/ 2.0
    else
        ArcXOffset(0) = DiameterDelta/ 2.0
        ArcXOffset(1) = -DiameterDelta/ 2.0
    End If

    if (CClockwise) then
        coil_offset = 1
    else
        coil_offset = 0
    end if

    FOR idx = (1-coil_offset) TO (NumTurns * 2 - coil_offset)

        shift = idx mod 2
        'Place arc section
        Arc = PCBServer.PCBObjectFactory(eArcObject, eNoDimension, eCreate_Default)
        Arc.LineWidth  = MilsToCoord(TraceWidth)
        Arc.XCenter    = MilsToCoord(CenterX + ArcXOffset(shift))
        Arc.YCenter    = MilsToCoord(CenterY)
        Arc.Radius     = MilsToCoord(CenterDiameter)
        Arc.Layer      = Layer
        If (shift = 0) Then
            Arc.StartAngle = 0
            Arc.EndAngle   = 180
        else
            Arc.StartAngle = 180
            Arc.EndAngle   = 0
        end if
        Board.AddPCBObject(Arc)

        CenterDiameter = CenterDiameter + DiameterDelta
    Next

End Sub   'Make_Spiral()







Sub Main
     spr2form.showmodal
End Sub
Sub XPBitBtn2Click(Sender)
    close
End Sub

Sub MetricClick(Sender)
    If    Metric.Checked Then
          Xloc.Text = (Xloc.Text / 39.37)
          Yloc.Text = (Yloc.Text / 39.37)
          ViaDia.Text = (ViaDia.Text / 39.37)
          Drill.Text = (Drill.Text / 39.37)
          GSpacing.Text = (GSpacing.Text / 39.37)
          GWidth.Text = (GWidth.Text / 39.37)
          GCenter.Text = (GCenter.Text / 39.37)
                Label10.Caption = "mm"
                Label11.Caption = "mm"
                Label12.Caption = "mm"
                Label13.Caption = "mm"
                Label14.Caption = "mm"

    Else
          Xloc.Text = (Xloc.Text * 39.37)
          Yloc.Text = (Yloc.Text * 39.37)
          ViaDia.Text = (ViaDia.Text * 39.37)
          Drill.Text = (Drill.Text * 39.37)
          GSpacing.Text = (GSpacing.Text * 39.37)
          GWidth.Text = (GWidth.Text * 39.37)
          GCenter.Text = (GCenter.Text * 39.37)

                Label10.Caption = "mil"
                Label11.Caption = "mil"
                Label12.Caption = "mil"
                Label13.Caption = "mil"
                Label14.Caption = "mil"
    End If
End Sub


